<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * Class Request
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     *
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("UserApplication")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete\UserApplication")
     *
     * @var UserApplication
     */
    protected $userApplication;

    /**
     * @param Credentials $credentials
     *
     * @return $this
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;

        return $this;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param UserApplication $userApplication
     *
     * @return $this
     */
    public function setUserApplication(UserApplication $userApplication)
    {
        $this->userApplication = $userApplication;

        return $this;
    }

    /**
     * @return UserApplication
     */
    public function getUserApplication()
    {
        return $this->userApplication;
    }
}