<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplication")
 *
 * Class UserApplication
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete
 */
class UserApplication
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Delete\Delete")
     *
     * @var Delete
     */
    protected $delete;

    /**
     * @param $userTypeIdentifier
     * @param $applicationTypeName
     */
    public function setUserApplicationTypeData($userTypeIdentifier, $applicationTypeName)
    {
        $userType = new UserType();
        $userType->setIdentifier($userTypeIdentifier);
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationTypeName);

        $key = new Key();
        $delete = new Delete();

        $key->setUserType($userType);
        $key->setApplicationType($applicationType);
        $delete->setKey($key);

        $this->setDelete($delete);
    }

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return $this
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
