<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplicationAttribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add
 */
class UserApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @param string $identifier
     * @param string $applicationName
     * @param string $attrName
     * @param string $attrType
     * @param string|array $attrValues
     */
    public function setUserApplicationAttribute(
        $identifier,
        $applicationName,
        $attrName,
        $attrType,
        $attrValues
    ) {
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $add = new Add();
        $key = new Key();
        $value = new Value();

        $key
            ->setUserType($userType)
            ->setApplicationType($applicationType);
        $add->setKey($key);

        $attrValues = is_array($attrValues) ? $attrValues : [$attrValues];
        foreach ($attrValues as $attrValue) {
            $attributeType = new AttributeType();
            $attributeType
                ->setName($attrName)
                ->setType($attrType)
                ->setValue($attrValue);
            $value->addAttributeType($attributeType);
        }

        $add->setValue($value);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return UserApplicationAttribute
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
