<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * Class Request
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     *
     * @var Credentials
     */
    private $credentials;

    /**
     * @Serializer\SerializedName("UserApplicationAttribute")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete\UserApplicationAttribute")
     *
     * @var UserApplicationAttribute
     */
    private $userApplicationAttribute;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @return UserApplicationAttribute
     */
    public function getUserApplicationAttribute()
    {
        return $this->userApplicationAttribute;
    }

    /**
     * @param UserApplicationAttribute $userApplicationAttribute
     * @return Request
     */
    public function setUserApplicationAttribute(UserApplicationAttribute $userApplicationAttribute)
    {
        $this->userApplicationAttribute = $userApplicationAttribute;

        return $this;
    }
}
