<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplicationAttribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete
 */
class UserApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Delete\Delete")
     *
     * @var Delete
     */
    private $delete;

    /**
     * @param string $identifier
     * @param string $applicationName
     * @param string $attrName
     */
    public function setUserApplicationAttribute(
        $identifier,
        $applicationName,
        $attrName
    ) {
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $attributeType = new AttributeType();
        $attributeType->setName($attrName);

        $delete = new Delete();
        $key = new Key();

        $key
            ->setUserType($userType)
            ->setApplicationType($applicationType)
            ->setAttributeType($attributeType);
        $delete->setKey($key);

        $this->setDelete($delete);
    }

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return UserApplicationAttribute
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
