<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplicationRole")
 *
 * Class UserApplication
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete
 */
class UserApplicationRole
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete\Delete")
     *
     * @var Delete
     */
    protected $delete;

    /**
     * @param string $identifier
     * @param string $applicationName
     * @param string $roleName
     */
    public function setUserApplicationRoleTypeData($identifier, $applicationName, $roleName)
    {
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $roleType = new RoleType();
        $roleType->setName($roleName);

        $key = new Key();
        $delete = new Delete();

        $key->setUserType($userType);
        $key->setApplicationType($applicationType);
        $key->setRoleType($roleType);
        $delete->setKey($key);

        $this->setDelete($delete);
    }

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return $this
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }
}
