<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserType")
 *
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Delete
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Identifier")
     * @Serializer\Type("string")
     * @var string
     */
    protected $identifier;

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return UserType
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;

        return $this;
    }
}
