<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserService
 *
 * @Serializer\XmlRoot("UserService")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest
 */
class UserService
{
    /**
     * @Serializer\SerializedName("ActivateRequest")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest\ActivateRequest")
     * @var ActivateRequest
     */
    protected $activateRequest;

    /**
     * @param string $identifier
     */
    public function setUserServiceData($identifier)
    {
        // Set UserType
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $key = new Key();
        $activateRequest = new ActivateRequest();

        $key->setUserType($userType);
        $activateRequest->setKey($key);

        $this->setActivateRequest($activateRequest);
    }

    /**
     * @return ActivateRequest
     */
    public function getActivateRequest()
    {
        return $this->activateRequest;
    }

    /**
     * @param ActivateRequest $activateRequest
     *
     * @return UserService
     */
    public function setActivateRequest(ActivateRequest $activateRequest)
    {
        $this->activateRequest = $activateRequest;

        return $this;
    }
}
