<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordConfirm;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserService
 *
 * @Serializer\XmlRoot("UserService")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordConfirm
 */
class UserService
{
    /**
     * @Serializer\SerializedName("PasswordConfirm")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordConfirm\PasswordConfirm")
     *
     * @var PasswordConfirm
     */
    private $passwordConfirm;

    /**
     * @param string $email
     * @param string $token
     * @param string $password
     */
    public function setUserService(
        $email,
        $token,
        $password
    ) {
        // Set UserType
        $keyUserType = new UserType();
        $valueUserType = new UserType();
        $keyUserType
            ->setEmail($email)
            ->setPasswordToken($token);
        $valueUserType->setPassword($password);

        $key = new Key();
        $value = new Value();
        $passwordConfirm = new PasswordConfirm();

        $key->setUserType($keyUserType);
        $value->setUserType($valueUserType);
        $passwordConfirm
            ->setKey($key)
            ->setValue($value);

        $this->setPasswordConfirm($passwordConfirm);
    }

    /**
     * @return PasswordConfirm
     */
    public function getPasswordConfirm()
    {
        return $this->passwordConfirm;
    }

    /**
     * @param PasswordConfirm $passwordConfirm
     * @return UserService
     */
    public function setPasswordConfirm(PasswordConfirm $passwordConfirm)
    {
        $this->passwordConfirm = $passwordConfirm;

        return $this;
    }
}
