<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserService
 *
 * @Serializer\XmlRoot("UserService")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest
 */
class UserService
{
    /**
     * @Serializer\SerializedName("PasswordRequest")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\PasswordRequest\PasswordRequest")
     *
     * @var PasswordRequest
     */
    private $passwordRequest;

    /**
     * @param string $identifier
     */
    public function setUserService(
        $identifier
    ) {
        // Set UserType
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $key = new Key();
        $passwordRequest = new PasswordRequest();

        $key->setUserType($userType);
        $passwordRequest->setKey($key);

        $this->setPasswordRequest($passwordRequest);
    }

    /**
     * @return PasswordRequest
     */
    public function getPasswordRequest()
    {
        return $this->passwordRequest;
    }

    /**
     * @param PasswordRequest $passwordRequest
     * @return UserService
     */
    public function setPasswordRequest(PasswordRequest $passwordRequest)
    {
        $this->passwordRequest = $passwordRequest;

        return $this;
    }
}
