<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("User")
 *
 * Class User
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Add
 */
class User
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Add\Add")
     *
     * @var Add
     */
    protected $add;

    /**
     * @param $email
     * @param $userName
     * @param $firstName
     * @param $lastName
     * @param $password
     * @param $active
     * @param $autId
     * @param $ldapSearchAttribute
     * @param $ldapSearchValue
     * @param $mfaEnabled
     */
    public function setUserData(
        $email,
        $userName,
        $firstName,
        $lastName,
        $password,
        $active,
        $autId,
        $ldapSearchAttribute,
        $ldapSearchValue,
        $mfaEnabled
    ) {
        $userType = new UserType();
        $userType->setEmail($email)
            ->setUsername($userName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setPassword($password)
            ->setActive($active)
            ->setAuthId($autId)
            ->setLdapSearchAttributes($ldapSearchAttribute)
            ->setLdapSearchValue($ldapSearchValue);
        $userType->setMfaEnabled($mfaEnabled);

        $value = new Value();
        $add = new Add();

        $value->setUserType($userType);
        $add->setValue($value);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return User
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
