<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("User")
 *
 * Class User
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update
 */
class User
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update\Update")
     *
     * @var Update
     */
    protected $update;

    /**
     * @param $email
     * @param $userName
     * @param $firstName
     * @param $lastName
     * @param $password
     * @param $active
     * @param $autId
     * @param $ldapSearchAttribute
     * @param $ldapSearchValue
     * @param $mfaEnabled
     */
    public function setUserData(
        $email,
        $userName,
        $firstName,
        $lastName,
        $active,
        $autId,
        $ldapSearchAttribute,
        $ldapSearchValue,
        $mfaEnabled,
        $mfaRecreate
    ) {
        $userType = new UserType();
        $userType->setEmail($email)
            ->setUsername($userName)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setActive($active)
            ->setAuthId($autId)
            ->setLdapSearchAttributes($ldapSearchAttribute)
            ->setLdapSearchValue($ldapSearchValue);
        $userType->setMfaEnabled($mfaEnabled);
        $userType->setMfaRecreate($mfaRecreate);

        $value = new Value();
        $update = new Update();

        $value->setUserType($userType);
        $update->setValue($value);

        $this->setUpdate($update);
    }

    /**
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param Update $update
     * @return User
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;

        return $this;
    }
}
