<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\ShowDetails;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @Serializer\XmlRoot("UserApplication")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\ShowDetails
 */
class UserApplication
{

    /**
     * @Serializer\SerializedName("ShowDetails")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\ShowDetails\ShowDetails")
     * @var ShowDetails
     */
    protected $showDetails;


    /**
     * @param string $identifier
     * @param array|null $appName
     */
    public function setUserApplicationData($identifier, array $appNames = null)
    {
        $showDetailsModel = new ShowDetails();
        $keyModel = new Key();
        $userTypeModel = new UserType();
        $userTypeModel->setIdentifier($identifier);
        $keyModel->setUserType($userTypeModel);

        if (null !== $appNames) {
            $appModel = new ApplicationType();
            foreach ($appNames as $appName) {
                $appModel->addName($appName);
            }

            $keyModel->setApplicationType($appModel);
        }

        $showDetailsModel->setKey($keyModel);
        $this->setShowDetails($showDetailsModel);
    }

    /**
     * @return ShowDetails
     */
    public function getShowDetails()
    {
        return $this->showDetails;
    }

    /**
     * @param ShowDetails $showDetails
     * @return UserApplication
     */
    public function setShowDetails($showDetails)
    {
        $this->showDetails = $showDetails;

        return $this;
    }
}
