<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationAttribute\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplicationAttribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationAttribute\Show
 */
class UserApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationAttribute\Show\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @param string $identifier
     * @param string $applicationName
     */
    public function setUserApplicationAttribute(
        $identifier,
        $applicationName
    ) {
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $key = new Key();
        $show = new Show();

        $key
            ->setUserType($userType)
            ->setApplicationType($applicationType);

        $show->setKey($key);

        $this->setShow($show);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return UserApplicationAttribute
     */
    public function setShow(Show $show)
    {
        $this->show = $show;

        return $this;
    }
}
