<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Key
 *
 * @Serializer\XmlRoot("Key")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show
 */
class Key
{
    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show\UserType")
     * @var UserType
     */
    protected $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplicationRole\Show\ApplicationType")
     * @var ApplicationType
     */
    protected $applicationType;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return $this
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return $this
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }
}
