<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\Filters;

/**
 * Class Advanced
 *
 * @Serializer\XmlRoot("Advanced")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\Advanced
 */
final class Advanced
{
    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $limit;

    /**
     * @Serializer\SerializedName("OrderBy")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderBy;

    /**
     * @Serializer\SerializedName("OrderDir")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderDir;

    /**
     * @Serializer\SerializedName("FullResponse")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $fullResponse;

    /**
     * @Serializer\SerializedName("Filters")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\Filters")
     * @var Filters
     */
    private $filters;

    /**
     * @return integer
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param integer $offset
     * @return Advanced
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return integer
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param integer $limit
     * @return Advanced
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }

    /**
     * @param string $orderBy
     * @return Advanced
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOrderDir()
    {
        return $this->orderDir;
    }

    /**
     * @param mixed $orderDir
     * @return Advanced
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;

        return $this;
    }

    /**
     * @return integer
     */
    public function getFullResponse()
    {
        return $this->fullResponse;
    }

    /**
     * @param mixed $fullResponse
     * @return Advanced
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;

        return $this;
    }

    /**
     * @return Filters
     */
    public function getFilters()
    {
        return $this->filters;
    }

    /**
     * @param Filters $filters
     * @return Advanced
     */
    public function setFilters($filters)
    {
        $this->filters = $filters;

        return $this;
    }
}
