<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplication;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserSearch
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplication
 */
class UserSearch
{
    /**
     * @Serializer\SerializedName("FindByApplication")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplication\FindByApplication")
     *
     * @var FindByApplication
     */
    private $findByApplication;

    /**
     * @param string $appName
     * @param integer $appActive
     * @param null|string $modifiedAfter
     */
    public function setUserSearch(
        $appName,
        $appActive,
        $modifiedAfter = null
    ) {
        $applicationType = new ApplicationType();
        $applicationType
            ->setName($appName)
            ->setActive($appActive);

        $key = new Key();
        $findByApplication = new FindByApplication();

        if (!empty($modifiedAfter)) {
            $userType = new UserType();
            $userType->setModifiedAfter(new \DateTime($modifiedAfter));

            $key->setUserType($userType);
        }

        $key->setApplicationType($applicationType);

        $findByApplication->setKey($key);

        $this->setFindByApplication($findByApplication);
    }

    /**
     * @return FindByApplication
     */
    public function getFindByApplication()
    {
        return $this->findByApplication;
    }

    /**
     * @param FindByApplication $findByApplication
     * @return UserSearch
     */
    public function setFindByApplication(FindByApplication $findByApplication)
    {
        $this->findByApplication = $findByApplication;

        return $this;
    }
}
