<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserSearch
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole
 */
class UserSearch
{
    /**
     * @Serializer\SerializedName("FindByApplicationRole")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole\FindByApplicationRole")
     *
     * @var FindByApplicationRole
     */
    private $findByApplicationRole;

    /**
     * @param string $appName
     * @param integer $appActive
     * @param string $roleName
     * @param integer $roleActive
     * @param null|string $modifiedAfter
     */
    public function setUserSearch(
        $appName,
        $appActive,
        $roleName,
        $roleActive,
        $modifiedAfter = null
    ) {
        $applicationType = new ApplicationType();
        $applicationType
            ->setName($appName)
            ->setActive($appActive);

        $roleType = new RoleType();
        $roleType
            ->setName($roleName)
            ->setActive($roleActive);

        $key = new Key();
        $findByApplicationRole = new FindByApplicationRole();

        if (!empty($modifiedAfter)) {
            $userType = new UserType();
            $userType->setModifiedAfter(new \DateTime($modifiedAfter));

            $key->setUserType($userType);
        }

        $key
            ->setApplicationType($applicationType)
            ->setRoleType($roleType);

        $findByApplicationRole->setKey($key);

        $this->setFindByApplicationRole($findByApplicationRole);
    }

    /**
     * @return FindByApplicationRole
     */
    public function getFindByApplicationRole()
    {
        return $this->findByApplicationRole;
    }

    /**
     * @param FindByApplicationRole $findByApplicationRole
     * @return UserSearch
     */
    public function setFindByApplicationRole(FindByApplicationRole $findByApplicationRole)
    {
        $this->findByApplicationRole = $findByApplicationRole;

        return $this;
    }
}
