<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserType")
 *
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserSearch\FindByApplicationRole
 */
class UserType
{
    /**
     * @Serializer\SerializedName("ModifiedAfter")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $modifiedAfter;

    /**
     * @return \DateTime
     */
    public function getModifiedAfter()
    {
        return $this->modifiedAfter;
    }

    /**
     * @param \DateTime|null $modifiedAfter
     * @return UserType
     */
    public function setModifiedAfter($modifiedAfter = null)
    {
        $this->modifiedAfter = $modifiedAfter;

        return $this;
    }
}
