<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return IdpWs\Factory
     */
    public function idpWs()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new IdpWs\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ObjectWs\Factory
     */
    public function objectWs()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectWs\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserWs\Factory
     */
    public function userWs()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserWs\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
