<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Update\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 *
 * @Serializer\XmlRoot("Attribute")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Update\Success
 */
class Update
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Attribute\Update\Success\AttributeType")
     *
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Update
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     * @return Update
     */
    public function setAttributeType(AttributeType $attributeType)
    {
        $this->attributeType = $attributeType;

        return $this;
    }
}
