<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Error Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Accessor(getter="getTrackId",setter="setTrackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("AttributeGroup")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\AttributeGroup\Update\Error\AttributeGroup")
     *
     * @var AttributeGroup
     */
    private $attributeGroup;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param string $date
     * @return Response
     */
    public function setDate($date)
    {
        $this->date = new \DateTime($date);

        return $this;
    }

    /**
     * @return AttributeGroup
     */
    public function getAttributeGroup()
    {
        return $this->attributeGroup;
    }

    /**
     * @param AttributeGroup $attributeGroup
     * @return Response
     */
    public function setAttributeGroup(AttributeGroup $attributeGroup)
    {
        $this->attributeGroup = $attributeGroup;

        return $this;
    }
}
