<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Object\Factory
     */
    public function object()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Object\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ObjectValue\Factory
     */
    public function objectValue()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectValue\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ObjectType\Factory
     */
    public function objectType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ObjectType\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Language\Factory
     */
    public function language()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Language\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
