<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object
 */
class Factory
{
    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Add\Factory
     */
    public function put()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Add\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Show\Factory
     */
    public function show()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Show\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Update\Factory
     */
    public function update()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Update\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Delete\Factory
     */
    public function delete()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
