<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Child
 *
 * @Serializer\XmlRoot("Children")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success
 */
class Child
{
    /**
     * @Serializer\SerializedName("TypeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeGuid;

    /**
     * @Serializer\SerializedName("TypeName")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeName;

    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("ReferenceId")
     * @Serializer\Type("string")
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("ParentGuid")
     * @Serializer\Type("string")
     * @var string
     */
    private $parentGuid;


    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Created")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("Updated")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $updated;

    /**
     * @Serializer\SerializedName("Children")
     * @Serializer\XmlList(entry="ObjectType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success\Child>")
     *
     * @var ArrayCollection
     */
    private $children;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\Object\Show\Tree\Success\Attribute>")
     * @Serializer\XmlList(entry="Attribute")
     *
     * @var ArrayCollection
     */
    private $attributes;

    /**
     * @Serializer\Exclude()
     *
     * @var Mapper
     */
    private $mapper;

    public function __construct(Mapper $mapper)
    {
        $this->mapper = $mapper;

        $this->children = new ArrayCollection();
        $this->attributes = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getTypeGuid()
    {
        return $this->typeGuid;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $typeGuid
     */
    public function setTypeGuid($typeGuid)
    {
        $this->typeGuid = $typeGuid;
    }

    /**
     * @param string $typeName
     * @return ObjectType
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
    }

    /**
     * @param string $referenceId
     * @return Child
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @param string $parentGuid
     * @return Child
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;

        return $this;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @param \DateTime $created
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }

    /**
     * @param \DateTime $updated
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }

    /**
     * Set children
     *
     * @param Child[] $children
     * @return Child
     */
    public function setChildren($children)
    {
        $this->children = $children;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Get attributes
     *
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Attribute $attribute
     * @return $this
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;

        return $this;
    }
}
