<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("Add")
 */
class TypeType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("TypeOrder")
     * @Serializer\Type("string")
     * @var string
     */
    private $order;

    /**
     * @Serializer\SerializedName("Created")
     * @Serializer\Type("string")
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("Updated")
     * @Serializer\Type("string")
     * @var string
     */
    private $updated;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param string $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     */
    public function setCreated($created)
    {
        $this->created = $created;
    }

    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $updated
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
    }
}
