<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 * @package Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectType\Update\ObjectTypeUpdate\Error\Type")
     * @var Type
     */
    private $objectType;

    /**
     * @Serializer\SerializedName("?")
     * @Serializer\Type("string")
     * @var string
     */
    private $object;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->Status = $status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @param string $trackid
     */
    public function setTrackid($trackid)
    {
        $this->Trackid = $trackid;
    }

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $date
     */
    public function setDate($date)
    {
        $this->Date = $date;
    }

    /**
     * @return Type
     */
    public function getType()
    {
        return $this->objectType;
    }

    /**
     * @param Type $type
     */
    public function setType($type)
    {
        $this->objectType = $type;
    }
}
