<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Add\Error;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Add\Error
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("ObjectValue")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Add\Error\ObjectValue")
     * @var ObjectValue
     */
    private $objectValue;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->Status = $status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @param string $trackid
     */
    public function setTrackid($trackid)
    {
        $this->Trackid = $trackid;
    }

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $date
     */
    public function setDate($date)
    {
        $this->Date = $date;
    }

    /**
     * @return ObjectValue
     */
    public function getObjectValue()
    {
        return $this->objectValue;
    }

    /**
     * @param ObjectValue $objectValue
     * @return Response
     */
    public function setObjectValue($objectValue)
    {
        $this->objectValue = $objectValue;
        return $this;
    }
}
