<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Show\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Show
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Show\Success
 */
class Show
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("string")
     * @var string
     */
    private $Count;

    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Show\Success\ObjectValueType>")
     * @Serializer\XmlList(inline=true, entry="ObjectValueType")
     * @var ObjectValueType[]
     */
    private $objectValueType;

    public function __construct()
    {
        $this->objectValueType = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $Status
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->Count;
    }

    /**
     * @param string $Count
     */
    public function setCount($Count)
    {
        $this->Count = $Count;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    /**
     * @return ObjectValueType[]
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

    /**
     * @param ObjectValueType[] $objectValueType
     * @return Show
     */
    public function setObjectValueType($objectValueType)
    {
        $this->objectValueType = $objectValueType;
        return $this;
    }
}
