<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectValue
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success
 */
class ObjectValue
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\ObjectWs\Version1\ObjectValue\Update\Success\Update")
     *
     * @var Update
     */
    private $update;

    /**
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param Update $update
     * @return ObjectValue
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;

        return $this;
    }
}
