<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationAttribute\Show\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationAttribute
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationAttribute\Show\Success
 */
class ApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\ApplicationAttribute\Show\Success\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return ApplicationAttribute
     */
    public function setShow(Show $show)
    {
        $this->show = $show;

        return $this;
    }
}
