<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\Attribute\Add\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\Attribute\Add\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     *
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("Attribute")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\Attribute\Add\Success\Attribute")
     *
     * @var Attribute
     */
    private $attribute;

    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version1\Attribute\Add\Success\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     */
    public function setAdd($add)
    {
        $this->add = $add;
    }

    /**
     * @return Attribute
     */
    public function getAttribute()
    {
        return $this->attribute;
    }

    /**
     * @param Attribute $attribute
     */
    public function setAttribute($attribute)
    {
        $this->attribute = $attribute;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     * @param string $Status
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;
    }

    /**
     * @param string $Trackid
     */
    public function setTrackid($Trackid)
    {
        $this->Trackid = $Trackid;
    }

    /**
     * @param string $Date
     */
    public function setDate($Date)
    {
        $this->Date = $Date;
    }
}
