<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version1\UserService
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return ActivateRequest\Factory
     */
    public function activateRequest()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ActivateRequest\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ActivateConfirm\Factory
     */
    public function activateConfirm()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ActivateConfirm\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PasswordRequest\Factory
     */
    public function passwordRequest()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new PasswordRequest\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return PasswordConfirm\Factory
     */
    public function passwordConfirm()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new PasswordConfirm\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
