<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 * @package Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("string")
     * @var string
     */
    private $active;

    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     * @var AttributeType[]
     */
    private $attributeType;

    /**
     * @Serializer\SerializedName("ApplicationRoleType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success\ApplicationRoleType>")
     * @Serializer\XmlList(inline=true, entry="ApplicationRoleType")
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType;


    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
        $this->applicationRoleType = new ArrayCollection();
    }


    /**
     * @return ApplicationRoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }

    /**
     * @param ApplicationRoleType[] $applicationRoleType
     */
    public function setApplicationRoleType($applicationRoleType)
    {
        $this->applicationRoleType->add($applicationRoleType);
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType[] $attributeType
     */
    public function setAttributeType($attributeType)
    {
        $this->attributeType->add($attributeType);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param string $active
     */
    public function setActive($active)
    {
        $this->active = $active;
    }


}