<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

class ShowDetails
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success\ApplicationType>")
     * @Serializer\XmlList(inline=true,entry="ApplicationType")
     * @var ApplicationType[]
     */
    private $applicationType;


    public function __construct()
    {
        $this->applicationType = new ArrayCollection();
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType[] $applicationType
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType->add($applicationType);
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;
    }

    /**
     * @return int
     */
    public function countApplicationType()
    {
        return $this->applicationType->count() > 0 ? $this->applicationType->count() : 0;
    }
}
