<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplication\ShowDetails\Success
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("Firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("Lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("string")
     * @var string
     */
    private $active;

    /**
     * @Serializer\SerializedName("Deleted")
     * @Serializer\Type("string")
     * @var string
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("AuthId")
     * @Serializer\Type("string")
     * @var string
     */
    private $authId;

    /**
     * @Serializer\SerializedName("LdapSearchAttributes")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @Serializer\SerializedName("LdapSearchValue")
     * @Serializer\Type("string")
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $mfaEnabled;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = $username;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;
    }

    /**
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param string $active
     */
    public function setActive($active)
    {
        $this->active = $active;
    }

    /**
     * @return string
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param string $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     * @return UserType
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;
        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return UserType
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;
        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     * @return UserType
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param int $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }
}
