<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Annotation\XmlList;

/**
 * Class UserType
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Success
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $active;

    /**
     * @Serializer\SerializedName("RoleType")
     * @XmlList(inline = true, entry = "RoleType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationRole\Show\Success\RoleType>")
     *
     * @var ArrayCollection|RoleType[]
     */
    private $roleType;

    public function __construct()
    {
        $this->roleType = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param string $active
     *
     * @return $this
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return RoleType[]|ArrayCollection
     */
    public function getRoleType()
    {
        return $this->roleType;
    }

    /**
     * @param RoleType $roleType
     *
     * @return $this
     */
    public function setRoleType($roleType)
    {
        if (!$this->roleType->contains($roleType)) {
            $this->roleType->add($roleType);
        }

        return $this;
    }
}
