<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\Advanced\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\User;

/**
 * Class Users
 * @package Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\Advanced\Success
 */
final class Users
{
    /**
     * @Serializer\SerializedName("User")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\User>")
     * @Serializer\XmlList(inline = true, entry = "User")
     * @var User[]
     */
    private $users;


    public function __construct()
    {
        $this->users = new ArrayCollection();
    }

    /**
     * @param User $user
     * @return Users
     */
    public function addUser(User $user)
    {
        $this->users->add($user);

        return $this;
    }

    /**
     * @return User[]
     */
    public function getUsers()
    {
        return $this->users;
    }
}
