<?php

/**
 * Class AttributeGroupControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\Controller\ObjectWs\Version1;

use Sso\RestBundle\Controller\ObjectWs\Version1\AttributeGroupController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use GuzzleHttp\Psr7\Response;
use Sso\RestBundle\Worker as Worker;
use Sso\RestBundle\Tests\Controller\BaseTestCase;
use LifeStyle\Tools\RestErrorBundle\Api\Error\Factory as ErrorFactory;
use LifeStyle\Tools\RestErrorBundle\Api\Manager as ErrorManager;
use Sso\RestBundle\Api\Manager as ApiManager;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Exception\RequestException;
use LifeStyle\Tools\ElkLogFormatterBundle\Monolog\Processor\TrackId;

/**
 * Class AttributeGroupControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\Controller
 */
class AttributeGroupControllerTest extends BaseTestCase
{


    public function testXmlPutAttributeGroupSuccess()
    {

        $this->container->get('lifestyle.elk.monolog.processor.trackid')->setTrackId('00000');
        $clientMock = $this->getMockedClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/AttributeGroup/Put/success.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->attributeGroup()->add();

        $server = [
            'REQUEST_URI' => '/api/v1/attribute/group.xml',
            'REQUEST_METHOD' => 'PUT',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents(__DIR__ . '../../../RequestBody/ObjectWs/Version1/AttributeGroup/Add/success.xml')
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\AttributeGroup\Add\Handler($apiM);

        $view = $handler->init($request);
        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');

        $response = preg_replace([
            '/<scriptTimeSec>(.*?)<\/scriptTimeSec>/i',
            '/<date>(.*?)<\/date>/i',
            '/<trackId>(.*?)<\/trackId>/i'
        ], '', $response);
        $this->assertEquals(200, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/AttributeGroup/Add/success.xml'),
            $response
        );
    }

    public function testXmlDeleteAttributeGroupSuccess()
    {

        $this->container->get('lifestyle.elk.monolog.processor.trackid')->setTrackId('00000');
        $clientMock = $this->getMockedClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/AttributeGroup/Delete/success.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->attributeGroup()->delete();

        $server = [
            'REQUEST_URI' => '/api/v1/attribute/group.xml',
            'REQUEST_METHOD' => 'DELETE',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents(__DIR__ . '../../../RequestBody/ObjectWs/Version1/AttributeGroup/Delete/success.xml')
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\AttributeGroup\Delete\Handler($apiM);

        $view = $handler->init($request);
        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');
        $response = preg_replace('/<scriptSeconds>(.*?)<\/scriptSeconds>/i', '', $response);
        $this->assertEquals(200, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/AttributeGroup/Delete/success.xml'),
            $response
        );
    }

    public function testXmlShowAttributeGroupSuccess()
    {

        $this->container->get('lifestyle.elk.monolog.processor.trackid')->setTrackId('00000');
        $clientMock = $this->getMockedClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/AttributeGroup/Get/success.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->attributeGroup()->show();

        $server = [
            'REQUEST_URI' => '/api/v1/attribute/group.xml',
            'REQUEST_METHOD' => 'SHOW',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server,
            file_get_contents(__DIR__ . '../../../RequestBody/ObjectWs/Version1/AttributeGroup/Get/success.xml')
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\AttributeGroup\Show\Handler($apiM);

        $view = $handler->init($request);
        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');

        $response = preg_replace('/<scriptSeconds>(.*?)<\/scriptSeconds>/i', '', $response);
        $this->assertEquals(200, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/AttributeGroup/Get/success.xml'),
            $response
        );
    }
}