<?php

/**
 * Class ObjectTypeControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\Controller;

use Sso\RestBundle\Controller\ObjectWs\Version1\ObjectTypeController;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;
use GuzzleHttp\Psr7\Response;
use Sso\RestBundle\Worker as Worker;
use Sso\RestBundle\Tests\Controller\BaseTestCase;
use LifeStyle\Tools\RestErrorBundle\Api\Error\Factory as ErrorFactory;
use LifeStyle\Tools\RestErrorBundle\Api\Manager as ErrorManager;
use Sso\RestBundle\Api\Manager as ApiManager;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Exception\RequestException;
use LifeStyle\Tools\ElkLogFormatterBundle\Monolog\Processor\TrackId;

/**
 * Class ObjectTypeControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\Tests\Controller
 */
class ObjectTypeControllerTest extends BaseTestCase
{

    public function testJsonGetObjectTypeSuccess()
    {
        $clientMock = $this->getMockedClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/ObjectType/Get/success.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->objectType()->show();

        $server = [
            'REQUEST_URI' => '/api/v1/objectType.json',
            'REQUEST_METHOD' => 'SHOW',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\Show\Handler($apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'json');
        $response = preg_replace('/"ScriptTimeSec["0-9:.]+,/i', '', $response);

        $this->assertEquals(200, $view->getStatusCode());
        $this->assertJsonStringEqualsJsonString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/ObjectType/Get/success.json'),
            $response
        );
    }

    public function testJsonGetObjectTypeErrorNoTypesFound()
    {

        $clientMock = $this->getMockedExceptionClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/ObjectType/Get/error_no_types_found.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->objectType()->show();

        $server = [
            'REQUEST_URI' => '/api/v1/objectType.json',
            'REQUEST_METHOD' => 'SHOW',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\Show\Handler($apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'json');
        $response = preg_replace('/"ScriptTimeSec["0-9:.]+,/i', '', $response);

        $this->assertEquals(400, $view->getStatusCode());
        $this->assertJsonStringEqualsJsonString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/ObjectType/Get/error_no_types_found.json'),
            $response
        );
    }

    public function testXmlGetObjectTypeSuccess()
    {
        $clientMock = $this->getMockedClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/ObjectType/Get/success.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->objectType()->show();

        $server = [
            'REQUEST_URI' => '/api/v1/objectType.json',
            'REQUEST_METHOD' => 'SHOW',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\Show\Handler($apiM);
        $view = $handler->init($request);

        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');
        $response = preg_replace('/<scriptTimeSec>(.*?)<\/scriptTimeSec>/i', '', $response);


        $this->assertEquals(200, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/ObjectType/Get/success.xml'),
            $response
        );
    }

    public function testXmlGetObjectTypeErrorNoTypesFound()
    {
        $clientMock = $this->getMockedExceptionClient(
            file_get_contents(__DIR__ . '../../../MockedResponse/ObjectWs/Version1/ObjectType/Get/error_no_types_found.xml')
        );

        $apiM = new ApiManager($this->container);
        $apiM->setClient($clientMock);

        $worker = new Worker\Worker($apiM);
        $worker->objectWs()->version1()->objectType()->show();

        $server = [
            'REQUEST_URI' => '/api/v1/objectType.json',
            'REQUEST_METHOD' => 'SHOW',
        ];

        // Prepare request and set request body and server request settings
        $request = new Request(
            [], [], [], [], [],
            $server
        );

        $handler = new \Sso\RestBundle\Worker\ObjectWs\Version1\ObjectType\Show\Handler($apiM);
        $view = $handler->init($request);
        $response = $this->container->get('serializer')->serialize($view->getData(), 'xml');
        $response = preg_replace('/<scriptTimeSec>(.*?)<\/scriptTimeSec>/i', '', $response);


        $this->assertEquals(400, $view->getStatusCode());
        $this->assertXmlStringEqualsXmlString(
            file_get_contents(__DIR__ . '../../../ExpectedResponse/ObjectWs/Version1/ObjectType/Get/error_no_types_found.xml'),
            $response
        );
    }

}