<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of newPHPClass
 *
 * @author minduser
 */

namespace Sso\RestBundle\Tests\ModelRest;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api;
use Sso\RestBundle\ModelRest;

class FactoryTest extends WebTestCase
{

    /**
     *
     * @var Api\Manager
     */
    public $apiM;

    /**
     *
     * @var Client
     */
    protected $client;

    /**
     *
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->apiM = new Api\Manager($this->container);
    }

    public function testSerializer()
    {
        // asserts
        $this->assertInstanceOf('\JMS\Serializer\Serializer', $this->apiM->serializer());
    }

    public function testLogger()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Bridge\Monolog\Logger', $this->apiM->logger());
    }

    public function testViewErrorsView()
    {
        // asserts
        $this->assertInstanceOf('\FOS\RestBundle\View\View',
            $this->apiM->errorManager()->error()->view()->getErrorsView(null));
    }

    public function testResponseResponse()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Component\HttpFoundation\Response',
            $this->apiM->errorManager()->error()->response()->response());
    }

    public function testResponseJson()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Component\HttpFoundation\JsonResponse',
            $this->apiM->errorManager()->error()->response()->jsonResponse());
    }

}
