<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\MultipleWs\Version1\ScopeObjects\Get;

use Sso\RestBundle\ModelRest\Request\MultipleWs\Version1\ScopeObjects\Get\Request;
use PHPUnit\Framework\TestCase;

/**
 * Class RequestTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\MultipleWs\Version1\ScopeObjects\Get
 */
class RequestTest extends TestCase
{
    public function testRequestModel()
    {
        $requestModel = new Request();

        $requestModel->setReferenceId('TEST00000');
        $requestModel->setApplicationName('APP4711');
        $requestModel->setIdentifier('some@o.ne');
        $requestModel->setLimit('13');
        $requestModel->setOffset('37');

        $this->assertEquals('TEST00000', $requestModel->getReferenceId());
        $this->assertEquals('APP4711', $requestModel->getApplicationName());
        $this->assertEquals('some@o.ne', $requestModel->getIdentifier());
        $this->assertEquals('13', $requestModel->getLimit());
        $this->assertEquals('37', $requestModel->getOffset());
    }
}
