<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\ObjectWs\Version1\AttributeGroup;

use Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\ObjectWs\Version1\AttributeGroup
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var AttributeGroup\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new AttributeGroup\Factory();
    }

    public function testAdd()
    {
        static::assertInstanceOf(AttributeGroup\Add\Request::class, $this->factory->add());
    }

    public function testShow()
    {
        static::assertInstanceOf(AttributeGroup\Show\Request::class, $this->factory->show());
    }

    public function testUpdate()
    {
        static::assertInstanceOf(AttributeGroup\Update\Request::class, $this->factory->update());
    }

    public function testDelete()
    {
        static::assertInstanceOf(AttributeGroup\Delete\Request::class, $this->factory->delete());
    }
}
