<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\ObjectWs\Version1\Object\Update;

use Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Update\Object;
use Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Update\Request;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $description;

    /**
     * @var string
     */
    private $referenceId;

    /**
     * @var string
     */
    private $typeId;

    /**
     * @var string
     */
    private $guid;

    /**
     * @var int
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->name = $this->faker->name;
        $this->description = $this->faker->sentence();
        $this->referenceId = $this->faker->md5;
        $this->guid = $this->faker->uuid;
        $this->typeId = $this->faker->uuid;
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $object = new Object();

        $object
            ->setGuid($this->guid)
            ->setReferenceId($this->referenceId)
            ->setTypeId($this->typeId)
            ->setParentGuid($this->guid)
            ->setName($this->name)
            ->setActive($this->active);

        $request->setObject($object);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "objects": [
                    {
                        "guid": "' . $this->guid . '",
                        "referenceId": "' . $this->referenceId . '",
                        "typeId": "' . $this->typeId . '",
                        "parentGuid": "' . $this->guid . '",
                        "name": "' . $this->name . '",
                        "active": ' . $this->active . '
                    }
                ]
            }';
        } else {
            return '<objectUpdate>
                <objects>
                    <object>
                        <guid><![CDATA[' . $this->guid . ']]></guid>
                        <referenceId><![CDATA[' . $this->referenceId . ']]></referenceId>
                        <typeId><![CDATA[' . $this->typeId . ']]></typeId>
                        <parentGuid><![CDATA[' . $this->guid . ']]></parentGuid>
                        <name><![CDATA[' . $this->name . ']]></name>
                        <active>' . $this->active . '</active>
                    </object>
                </objects>
            </objectUpdate>';
        }
    }

    public function testGetterAttributeType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $object = $requestModel->getObjects()->get(0);

        $this->assertEquals($this->guid, $object->getGuid());
        $this->assertEquals($this->referenceId, $object->getReferenceId());
        $this->assertEquals($this->typeId, $object->getTypeId());
        $this->assertEquals($this->guid, $object->getParentGuid());
        $this->assertEquals($this->name, $object->getName());
        $this->assertEquals($this->active, $object->getActive());
    }
}
