<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserApplication\Add;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\Application;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\UserApplication;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->identifier = $this->faker->email;
        $this->name = $this->faker->name;
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    public function testUserTypeGetter()
    {
        $request = new Request();
        $userType = new UserType();
        $applicationType = new ApplicationType();

        $applicationType
            ->setName($this->name)
            ->setActive($this->active);

        $userType
            ->setIdentifier($this->identifier)
            ->setApplicationType($applicationType);

        $request->addUserType($userType);
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userType = new UserType();
        $applicationType = new ApplicationType();

        $applicationType
            ->setName($this->name)
            ->setActive($this->active);

        $userType
            ->setIdentifier($this->identifier)
            ->setApplicationType($applicationType);

        $request->addUserType($userType);
        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "users": [
                    {
                        "identifier": "' . $this->identifier . '",
                        "applicationType": {
                            "name": "' . $this->name . '",
                            "active": ' . $this->active . '
                        }
                    }
                ]
            }';
        } else {
            return '<userApplicationAdd>
                <users>
                    <userType>
                        <identifier><![CDATA[' . $this->identifier . ']]></identifier>
                        <applicationType>
                            <name><![CDATA[' . $this->name . ']]></name>
                            <active>' . $this->active . '</active>
                        </applicationType>
                    </userType>
                </users>
            </userApplicationAdd>';
        }
    }

    public function testGetterUserType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $userType = $requestModel->getUserType()->get(0);

        $this->assertEquals($this->identifier, $userType->getIdentifier());
        $this->assertEquals($this->name, $userType->getApplicationType()->getName());
        $this->assertEquals($this->active, $userType->getApplicationType()->getActive());
    }

    public function testSetterGetterUserApplication()
    {
        $userApplication = new UserApplication();
        $application = new Application();

        $application->setName($this->name)->setActive($this->active);
        $userApplication->setIdentifier($this->identifier)->setApplication($application);

        $this->assertEquals($this->identifier, $userApplication->getIdentifier());
        $this->assertEquals($this->name, $userApplication->getApplication()->getName());
        $this->assertEquals($this->active, $userApplication->getApplication()->getActive());
    }
}
