<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserService;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserService
 */
class FactoryTest extends TestCase
{
    /**
     * @var UserService\Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        $this->factory = new UserService\Factory();
    }

    public function testActivateRequestRequest()
    {
        static::assertInstanceOf(UserService\ActivateRequest\Request::class, $this->factory->activateRequest());
    }

    public function testActivateConfirmRequest()
    {
        static::assertInstanceOf(UserService\ActivateConfirm\Request::class, $this->factory->activateConfirm());
    }

    public function testPasswordRequestRequest()
    {
        static::assertInstanceOf(UserService\PasswordRequest\Request::class, $this->factory->passwordRequest());
    }

    public function testPasswordConfirmRequest()
    {
        static::assertInstanceOf(UserService\PasswordConfirm\Request::class, $this->factory->passwordConfirm());
    }
}
