<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest;

use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest\UserPasswordRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $active;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->identifier = $this->faker->email;
        $this->name = $this->faker->name;
        $this->active = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    public function testUserTypeGetter()
    {
        $request = new Request();
        $userPasswordRequest = new UserPasswordRequest();
        $userType = new UserType();

        $userType->setIdentifier($this->identifier);
        $userPasswordRequest->addUserType($userType);

        $request->setUserPasswordRequest($userPasswordRequest);
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userPasswordRequest = new UserPasswordRequest();
        $userType = new UserType();

        $userType->setIdentifier($this->identifier);
        $userPasswordRequest->addUserType($userType);

        $request->setUserPasswordRequest($userPasswordRequest);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
                "userPasswordRequest": {
                    "userType": [
                        {
                            "identifier": "' . $this->identifier . '"
                        }
                    ]
                }
            }';
        } else {
            return '<userServicePasswordRequest>
                <userPasswordRequest>
                    <userType>
                        <identifier><![CDATA[' . $this->identifier . ']]></identifier>
                    </userType>
                </userPasswordRequest>
            </userServicePasswordRequest>';
        }
    }

    public function testGetterUserType()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $userType = $requestModel->getUserPasswordRequest()->getUserType()->get(0);

        $this->assertEquals($this->identifier, $userType->getIdentifier());
    }

    public function testSetterGetterUserService()
    {
        $userPasswordRequest = new UserPasswordRequest();
        $userType = new UserType();

        $userType->setIdentifier($this->identifier);

        $userPasswordRequest->addUserType($userType);

        $responseUserType = $userPasswordRequest->getUserType()->get(0);

        $this->assertEquals($this->identifier, $responseUserType->getIdentifier());
    }
}
