<?php

/**
 * Class FactoryTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserApplicationRole;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplicationRole\Factory;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplicationRole\Show;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserApplicationRole
 */
class FactoryTest extends WebTestCase
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * {@inheritDoc}
     */
    public function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->factory = new Factory();
    }

    public function testShow()
    {
        static::assertInstanceOf(Show\Request::class, $this->factory->show());
    }
}
