<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserSearch;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Factory;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced\Request as AdvancedRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\Request as FindByApplicationRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\Request as FindByApplicationAttributeRequest;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\Request as FindByApplicationRoleRequest;
use PHPUnit\Framework\TestCase;

/**
 * Class FactoryTest
 * @package Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserSearch
 */
class FactoryTest extends TestCase
{
    /**
     * @var Factory
     */
    private $factory;

    protected function setUp()
    {
        $this->factory = new Factory();
    }

    public function testAdvancedRequest()
    {
        $this->assertInstanceOf(AdvancedRequest::class, $this->factory->advanced());
    }

    public function testFindByApplicationRequest()
    {
        $this->assertInstanceOf(FindByApplicationRequest::class, $this->factory->findByApplication());
    }

    public function testFindByApplicationAttributeRequest()
    {
        $this->assertInstanceOf(FindByApplicationAttributeRequest::class, $this->factory->findByApplicationAttribute());
    }

    public function testFindByApplicationRoleRequest()
    {
        $this->assertInstanceOf(FindByApplicationRoleRequest::class, $this->factory->findByApplicationRole());
    }
}
