<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Tests\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication;

use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\ApplicationType;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\Request;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\UserByApplication;
use Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplication\UserType;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Sso\RestBundle\Api\Manager as ApiManager;
use JMS\Serializer\SerializerInterface;
use Faker\Factory as FakerFactory;
use Faker\Generator as FakerGenerator;

/**
 * Class RequestTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\Tests\ModelRest
 */
class RequestTest extends WebTestCase
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * @var FakerGenerator
     */
    private $faker;

    /**
     * @var string
     */
    private $modified;

    /**
     * @var string
     */
    private $appName;

    /**
     * @var integer
     */
    private $appActive;

    protected function setUp()
    {
        parent::setUp();
        static::bootKernel();
        $this->apiManager = new ApiManager(static::$kernel->getContainer());
        $this->serializer = $this->apiManager->serializer();
        $this->faker = FakerFactory::create();

        // Set same random data
        $this->modified = '2099-01-01T00:00:00+00:00';
        $this->appName = $this->faker->word;
        $this->appActive = $this->faker->boolean ? 1 : 0;
    }

    public function testJsonSerialize()
    {
        $this->assertJsonStringEqualsJsonString($this->getRequestBody('json'), $this->setRequestBody('json'));
    }

    public function testXmlSerialize()
    {
        $this->assertXmlStringEqualsXmlString($this->getRequestBody('xml'), $this->setRequestBody('xml'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function setRequestBody($type = 'xml')
    {
        $request = new Request();
        $userByApplication = new UserByApplication();
        $userType = new UserType();
        $applicationType = new ApplicationType();

        $applicationType
            ->setName($this->appName)
            ->setActive($this->appActive);

        $userType
            ->setModified($this->modified)
            ->setApplicationType($applicationType);

        $userByApplication->setUserType($userType);

        $request->setUserByApplication($userByApplication);

        return $this->serializer->serialize($request, ($type !== 'json' ? 'xml' : 'json'));
    }

    /**
     * @param string $type (xml | json)
     * @return string
     */
    private function getRequestBody($type = 'xml')
    {
        if ($type === 'json') {
            return '{
              "userByApplication": {
                  "userType": {
                    "modified": "' . $this->modified . '",
                    "applicationType": {
                      "name": "' . $this->appName . '",
                      "active": ' . $this->appActive . '
                    }
                  }
              }
            }';
        } else {
            return '<userSearchByApplication>
                <userByApplication>
                    <userType>
                        <modified><![CDATA[' . $this->modified . ']]></modified>
                        <applicationType>
                            <name><![CDATA[' . $this->appName . ']]></name>
                            <active>' . $this->appActive . '</active>
                        </applicationType>
                    </userType>
                </userByApplication>
            </userSearchByApplication>';
        }
    }

    public function testGetterUserSearchByApplication()
    {
        /** @var  Request $requestModel */
        $requestModel = $this->serializer->deserialize(
            $this->setRequestBody('json'),
            Request::class,
            'json'
        );

        $this->assertEquals($this->modified, $requestModel->getUserByApplication()->getUserType()->getModified());
        $this->assertEquals($this->appName,
            $requestModel->getUserByApplication()->getUserType()->getApplicationType()->getName());
        $this->assertEquals($this->appActive,
            $requestModel->getUserByApplication()->getUserType()->getApplicationType()->getActive());
    }
}
